package fr.ifremer.thredds;

import java.util.*;
import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import fr.ifremer.thredds.Dataset;


public class Catalog {

	public Catalog(String p_fileURL){
			
		_fileURL = new String(p_fileURL);
		int l_lastSlashIndex = _fileURL.lastIndexOf("/");
		_fileDirectoryURL = _fileURL.substring(0, l_lastSlashIndex + 1);
		
}
	
	public Catalog(String p_fileURL, 	
			boolean p_knownTimeCoverage, 
			boolean p_knownGeospatialCoverage, 
			boolean p_knownVariables){
		
		_fileURL = new String(p_fileURL);
		int l_lastSlashIndex = _fileURL.lastIndexOf("/");
		_fileDirectoryURL = _fileURL.substring(0, l_lastSlashIndex + 1);
		
		_knownTimeCoverage =  p_knownTimeCoverage;
		_knownGeospatialCoverage = p_knownGeospatialCoverage;
		_knownVariables = p_knownVariables;
		
}
	
	
	public boolean parseFile(){
		_isValid = true; // Valide jusqu'à ce qu'une erreur se produise !
				
		try {
			SAXParserFactory spf = SAXParserFactory.newInstance();
			spf.setNamespaceAware(true);
			spf.setValidating(true);
			SAXParser sp = spf.newSAXParser();
			sp.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
			sp.setProperty(JAXP_SCHEMA_SOURCE, _xsdFile);
			sp.parse(_fileURL, new DefaultHandler(){
				public void fatalError(SAXParseException e) {
					System.out.println("Erreur de validation XSD - Erreur fatal");					
					System.out.println(" line " + String.valueOf(e.getLineNumber())
							+ ", column : " +  String.valueOf(e.getColumnNumber())						
							+ " : " + e.getMessage());
					_isValid = false;
				}

				public void error(SAXParseException e) {
					System.out.println("Erreur de validation XSD - Erreur");
					System.out.println(" line " + String.valueOf(e.getLineNumber())
							+ ", column : " +  String.valueOf(e.getColumnNumber())						
							+ " : " + e.getMessage());
					_isValid = false;
				}

				public void warning(SAXParseException e) {
					System.out.println("Erreur de validation XSD - Warning");
					System.out.println(" line " + String.valueOf(e.getLineNumber())
							+ ", column : " +  String.valueOf(e.getColumnNumber())						
							+ " : " + e.getMessage());
					_isValid = false;
				}
			});
			
			DocumentBuilderFactory l_catalogDBF = DocumentBuilderFactory.newInstance();	
			DocumentBuilder l_db = l_catalogDBF.newDocumentBuilder();	
			_doc = l_db.parse(_fileURL);
			
		} catch (SAXException se) {
			System.out.println(se);
			return false;
		} catch (ParserConfigurationException pce){
			System.out.println(pce);
			return false;
		} catch (IOException ioe){
			System.out.println(ioe);
			return false;
		}
								
		
		return _isValid;
		
	}
	
	public boolean parseCatalog(){
		boolean l_isValid = true;
		Catalog l_tmpChildCatalog;
		System.out.println("Checking catalog file located at :" + _fileURL);
		l_isValid = this.parseFile();
		
		// Rechercher les catalogues imbriqués
		Object[] l_childCatalogRef = this.getCatalogAbsoluteReferences();
		for(int i=0 ; i<l_childCatalogRef.length ; i++){
			l_tmpChildCatalog = new Catalog(
					(String)l_childCatalogRef[i],
					this.getIsTimeCoverageTransmitted(),
					this.getIsGeospatialCoverageTransmitted(),
					this.getIsVariablesTransmitted());
			l_isValid = l_tmpChildCatalog.parseCatalog() && l_isValid;
		}
		
		// Rechercher les datasets imbriqués		
		Object[] l_childDataset = this.getDatasetChilds((Node)_doc.getDocumentElement());
		for(int i=0 ; i<l_childDataset.length ; i++){
			l_isValid = ((Dataset)l_childDataset[i]).parseDataset() && l_isValid;
			
		}
		
		return l_isValid;
		
		
	}
	
	
	// methode utilisée pour instancier les dataset d'un catalogue
	public Object[] getDatasetChilds(Node p_currentNode){
		NodeList l_childNodeList = p_currentNode.getChildNodes();		
		Node l_currentDatasetNode;
		Dataset l_currentChildDataset;
		ArrayList<Dataset> l_result = new ArrayList<Dataset>();
		
		for (int i=0 ; i < l_childNodeList.getLength() ; i++){
			l_currentDatasetNode = l_childNodeList.item(i);
			
			if("dataset".equals(l_currentDatasetNode.getNodeName())){
					l_currentChildDataset = new Dataset((Catalog)this,
								l_currentDatasetNode);
					l_result.add((Dataset)l_currentChildDataset);				
				
			}
		}
		return l_result.toArray();
	} 
	
	
	public Object[] getCatalogAbsoluteReferences(){
		Object[] l_result;
		Element l_fatherElement = _doc.getDocumentElement();
		l_result = this.getCatalogAbsoluteReferences(l_fatherElement);
		
		return l_result;
	
	}
	
	public Object[] getCatalogAbsoluteReferences(Element p_fatherElement){
		NodeList l_childNodeList = p_fatherElement.getChildNodes();
		Node l_currentCatalogRefNode;
		NamedNodeMap l_attributesNamedMap;
		Node l_currentHrefNode;
		ArrayList<String> l_result = new ArrayList<String>();
		String l_catalogRefRelativeURL;
		for (int i=0 ; i < l_childNodeList.getLength() ; i++){
			l_currentCatalogRefNode = l_childNodeList.item(i);
			if("catalogRef".equals(l_currentCatalogRefNode.getNodeName())){
				l_attributesNamedMap = l_currentCatalogRefNode.getAttributes();
				l_currentHrefNode = l_attributesNamedMap.getNamedItem("xlink:href");
				l_catalogRefRelativeURL = l_currentHrefNode.getNodeValue();
				if(l_catalogRefRelativeURL.startsWith("http")){
					l_result.add((String)l_catalogRefRelativeURL);
				}
				else{		
					l_result.add((String)_fileDirectoryURL.concat(l_catalogRefRelativeURL));
				}
				
				
			}
				
		
		}
		
		return l_result.toArray();
		
	}
	
	public boolean getIsTimeCoverageKnown(){
		return _knownTimeCoverage;
	}
	
	public boolean getIsGeospatialCoverageKnown(){
		return _knownGeospatialCoverage;
	}
	
	public boolean getIsVariablesKnown(){
		return _knownVariables;
	} 
	
	public boolean getIsTimeCoverageTransmitted(){
		return _knownTimeCoverage;
	}
	
	public boolean getIsGeospatialCoverageTransmitted(){
		return _knownGeospatialCoverage;
	}
	
	public boolean getIsVariablesTransmitted(){
		return _knownVariables;
	} 
	
	
	
	public String getCatalogFileURL(){
		return _fileURL;
	}
	
	private Document _doc;	
	private String _fileURL;
	private String _fileDirectoryURL;
	private boolean _isValid;
	
	private boolean _inheritedMetadata = false;
	private boolean _knownTimeCoverage = false;
	private boolean _knownGeospatialCoverage = false;	
	private boolean _knownVariables = false;
	
	
	static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

	static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

	static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

	static String _xsdFile = "";
	
	public static void setXsdFilePath(String p_filePath){
		_xsdFile = p_filePath;
	}
	
}
