package fr.ifremer.thredds;

import java.util.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;

import fr.ifremer.thredds.Catalog;

public class Dataset {
	private boolean _inheritedMetadata = false;
	private boolean _knownTimeCoverage = false;
	private boolean _knownGeospatialCoverage = false;	
	private boolean _knownVariables = false;	
	
	private boolean _transmittedTimeCoverage = false;
	private boolean _transmittedGeospatialCoverage = false;	
	private boolean _transmittedVariables = false;	
	
	private Node _currentNode;
	private Catalog _currentCatalog;
	
	


	public Dataset(Catalog p_currentCatalog,
			Node p_currentNode){
		
		_currentCatalog = p_currentCatalog;
		_currentNode = p_currentNode;
		
		// tester la présence de nouvelle métadonnées
		this.LocallyKnownMetadata();
		
		_knownTimeCoverage = _knownTimeCoverage || p_currentCatalog.getIsTimeCoverageTransmitted();
		_knownGeospatialCoverage = _knownGeospatialCoverage || p_currentCatalog.getIsGeospatialCoverageTransmitted();
		_knownVariables = _knownVariables || p_currentCatalog.getIsVariablesTransmitted();
		
		
	}
	

	public Dataset(Catalog p_currentCatalog,
			Node p_currentNode, 
			boolean p_knownTimeCoverage, 
			boolean p_knownGeospatialCoverage, 
			boolean p_knownVariables){
		
		_currentCatalog = p_currentCatalog;
		_currentNode = p_currentNode;
		
		// tester la présence de nouvelle métadonnées
		this.LocallyKnownMetadata();
		_knownTimeCoverage = _knownTimeCoverage || p_knownTimeCoverage;
		_knownGeospatialCoverage = _knownGeospatialCoverage || p_knownGeospatialCoverage;
		_knownVariables = _knownVariables || p_knownVariables;
		
		
	}
	
	public boolean parseDataset(){
		boolean l_isValid = true;
		Object[] l_childDatasets = this.getDatasetChilds();
		Object[] l_childCatalogRefURL  = _currentCatalog.getCatalogAbsoluteReferences((Element)_currentNode);
		Catalog l_tmpChildCatalog;
		
		int childDatasetsNumber = l_childDatasets.length;
		int childCatalogRefURLNumber = l_childCatalogRefURL.length;
		
		
		System.out.println("Exploration of dataset " + this.getDatasetName());
		// C'est un dataset feuille véritable
		if ((childDatasetsNumber == 0) && (childCatalogRefURLNumber == 0)){
			// Si au moins une des métadonées est absente
			if(!(_knownTimeCoverage && _knownGeospatialCoverage && _knownVariables)){
				l_isValid = false;
				System.out.println("one missing metadata for dataset : " 
						+ this.getDatasetName() 
						+ " in catalogue file : "
						+ _currentCatalog.getCatalogFileURL());
				System.out.println("------TimeCoverage is set :" + new Boolean(_knownTimeCoverage).toString());
				System.out.println("------GeospatialCoverage is set :" + new Boolean(_knownGeospatialCoverage).toString());
				System.out.println("------Variables are set :" + new Boolean(_knownVariables).toString());
				
			}else{
				System.out.println("metadata ok for dataset : " 
						+ this.getDatasetName() 
						+ " in catalogue file : "
						+ _currentCatalog.getCatalogFileURL());
			}
		}else{
			// C'est un dataset branche 
			// parce que des dataset sont accessibles dans le même catalogue
		    // alors on les explore
			
			for(int i=0 ; i<childDatasetsNumber ; i++){
				l_isValid = ((Dataset)l_childDatasets[i]).parseDataset() && l_isValid;
			}							
			// parce que des catalogues sont accessibles dans le même catalogue
		    // alors on les explore
			for(int i=0 ; i<childCatalogRefURLNumber ; i++){
				// TO DO Capturer l'exception si le catalogue n'existe pas ou n'est pas disponible
				l_tmpChildCatalog = new Catalog((String)l_childCatalogRefURL[i], 
						this.getIsTimeCoverageTransmitted(),
						this.getIsGeospatialCoverageTransmitted(),
						this.getIsVariablesTransmitted());
				l_isValid = l_tmpChildCatalog.parseCatalog() && l_isValid;
			}						
		}
		return l_isValid;
			
	}
	
	
	public Object[] getDatasetChilds(){
		NodeList l_childNodeList = _currentNode.getChildNodes();		
		Node l_currentDatasetNode;
		Dataset l_currentChildDataset;
		ArrayList<Dataset> l_result = new ArrayList<Dataset>();
		
		for (int i=0 ; i < l_childNodeList.getLength() ; i++){
			l_currentDatasetNode = l_childNodeList.item(i);
			
			if("dataset".equals(l_currentDatasetNode.getNodeName())){
					l_currentChildDataset = new Dataset(_currentCatalog,
								l_currentDatasetNode,
								this.getIsTimeCoverageTransmitted(),
								this.getIsGeospatialCoverageTransmitted(),
								this.getIsVariablesTransmitted());
					l_result.add((Dataset)l_currentChildDataset);				
				
			}
		}
		return l_result.toArray();
		
	}
	

		
	public boolean getIsTimeCoverageKnown(){
		return _knownTimeCoverage;
	}
	
	public boolean getIsGeospatialCoverageKnown(){
		return _knownGeospatialCoverage;
	}
	
	public boolean getIsVariablesKnown(){
		return _knownVariables;
	} 
	

	public boolean getIsTimeCoverageTransmitted(){
		return _knownTimeCoverage && _inheritedMetadata;
	}
	
	public boolean getIsGeospatialCoverageTransmitted(){
		return _knownGeospatialCoverage && _inheritedMetadata;
	}
	
	public boolean getIsVariablesTransmitted(){
		return _knownVariables && _inheritedMetadata;
	} 
	
	
	
	public String getDatasetName(){
		NamedNodeMap l_attributesNamedMap = _currentNode.getAttributes();
		Node l_currentNameNode = l_attributesNamedMap.getNamedItem("name");
		String l_datasetNameString = l_currentNameNode.getNodeValue();
		return l_datasetNameString;
		
	}
	
	private void LocallyKnownMetadata(){
		// ici on recherche quels métadonnées sont localement renseignées
		NodeList l_childNodeList = _currentNode.getChildNodes();
		Node l_currentMetadataNode;
		NodeList l_metadataInfoList;
		Node l_currentMetadataInfoNode;	
		for (int i=0 ; i < l_childNodeList.getLength() ; i++){
			l_currentMetadataNode = l_childNodeList.item(i);
			if("metadata".equals(l_currentMetadataNode.getNodeName())){
				// test si les métadata sont héritées (transmises aux enfants)
				NamedNodeMap l_namedMetadataAttributes = l_currentMetadataNode.getAttributes();
				Node l_inheritedAttribute = l_namedMetadataAttributes.getNamedItem("inherited");
				if(l_inheritedAttribute != null && ((String)l_inheritedAttribute.getNodeValue()).equals("true")){
					_inheritedMetadata = true;
				}
				
					// ici on recherche quels métadonnées sont localement renseignées
				l_metadataInfoList = l_currentMetadataNode.getChildNodes();
				for (int j=0 ; j < l_metadataInfoList.getLength() ; j++){
					l_currentMetadataInfoNode = l_metadataInfoList.item(j);
					if("timeCoverage".equals(l_currentMetadataInfoNode.getNodeName())){
						_knownTimeCoverage = true;
					}else if ("geospatialCoverage".equals(l_currentMetadataInfoNode.getNodeName())){
						_knownGeospatialCoverage = true;
					}else if ("variables".equals(l_currentMetadataInfoNode.getNodeName())){
						_knownVariables = true;					
					}
					
					
				
				}
			}
	
	
	}
	
	
	}
		
	
	
}
